<?php

  namespace App\Models;

  use Illuminate\Database\Eloquent\Model;

  class Report extends Model
  {
      protected $table = 'reports';
      protected $primaryKey = 'Report_id';
      public $timestamps = true;

      protected $fillable = [
          'User_id',
          'Report_type',
          'Total_amount',
          'Transaction_count',
          'Payment_status',
          'Report_date',
      ];

      public function user()
      {
          return $this->belongsTo(User::class, 'User_id', 'User_id');
      }
  }
